From: David Leaver <leaver@alphalink.com.au>
Subject: Eastern Front EFT18I.ASM
Date: Wednesday, December 02, 1998 12:21 PM

10 ;EFT VERSION 1.8I (INTERRUPT) 11/30/81 COPYRIGHT CHRIS CRAWFORD 1981
20 ;
30 ;Page zero RAM
40 ;
50 RTCLKL=$14
60 ATRACT=$4D
70 DRKMSK=$4E
80 COLRSH=$4F
90  *=$B0
0100 ;
0110 ;These locations are used by the interrupt service routine
0120 ;
0130 DLSTPT *=*+2 Zero page pointer to display list
0140 MAPLO *=*+1
0150 MAPHI *=*+1
0160 CORPS *=*+1 number of unit under window
0170 CURSXL *=*+1
0180 CURSXH *=*+1
0190 CURSYL *=*+1 cursor coordinates on screen (map frame)
0200 CURSYH *=*+1
0210 OFFLO *=*+1 How far to offset new LMS value
0220 OFFHI *=*+1
0230 TEMPI *=*+1 An all-purpose temporary register
0240 CNT1 *=*+1 DLI counter
0250 CNT2 *=*+1 DLI counter for movable map DLI
0260 CHUNKX *=*+1 cursor coordinates (pixel frame)
0270 CHUNKY *=*+1
0280 ;
0290 ;THIS VALUE IS USED BY MAINLINE ROUTINE AND INTERRUPT
0300 ;
0310 TURN=$C9
0320 ;
0330 ;OS locations (see OS manual)
0340 ;
0350 PCOLR0=$02C0
0360 STICK=$0278
0370 CH=$2FC
0380 ;
0390 ;HARDWARE LOCATIONS
0400 ;
0410 HPOSP0=$D000
0420 HPOSP1=$D001
0430 HPOSP2=$D002
0440 HPOSP3=$D003
0450 TRIG0=$D010
0460 TRIG1=$D011
0470 TRIG2=$D012
0480 COLPF0=$D016
0490 COLPF1=$D017
0500 COLPF2=$D018
0510 COLBAK=$D01A
0520 CONSOL=$D01F
0530 AUDF1=$D200
0540 AUDC1=$D201
0550 HSCROLL=$D404
0560 VSCROLL=$D405
0570 WSYNC=$D40A
0580 CHBASE=$D409
0590 SETVBV=$E45C
0600 XITVBV=$E462
0610 ;
0620 ;Page 6 usage
0630 ;
0640  *=$0600
0650 ;first come locations used by the interrupt service routine
0660 XPOSL *=*+1 Horizontal position of
0670 YPOSL *=*+1 Vertical position of
0680 YPOSH *=*+1 upper left corner of screen window
0690 SCY *=*+1 vert position of cursor (player frame)
0700 SHPOS0 *=*+1 shadows player 0 position
0710 TRCOLR *=*+1
0720 EARTH *=*+1
0730 ICELAT *=*+1
0740 SEASN1 *=*+1
0750 SEASN2 *=*+1
0760 SEASN3 *=*+1
0770 DAY *=*+1
0780 MONTH *=*+1
0790 YEAR *=*+1
0800 BUTFLG *=*+1
0810 BUTMSK *=*+1
0820 TYL *=*+1
0830 TYH *=*+1
0840 DELAY *=*+1 acceleration delay on scrolling
0850 TIMSCL *=*+1 frame to scroll in
0860 TEMPLO *=*+1 temporary
0870 TEMPHI *=*+1
0880 BASEX *=*+1 start position for arrow (player frame)
0890 BASEY *=*+1
0900 STEPX *=*+1 intermediate position of arrow
0910 STEPY *=*+1
0920 STPCNT *=*+1 which intermediate steps arrow is on
0930 ORDCNT *=*+1 which order arrow is showing
0940 ORD1 *=*+1 orders record
0950 ORD2 *=*+1
0960 ARRNDX *=*+1 arrow index
0970 HOWMNY *=*+1 how many orders for unit under cursor
0980 KRZX *=*+1 maltakreuze coords (player frame)
0990 KRZY *=*+1
1000 DBTIMR *=*+1 joystick debounce timer
1010 STICKI *=*+1 coded value of stick direction (0-3)
1020 ERRFLG *=*+1
1030 KRZFLG *=*+1
1040 STKFLG *=*+1
1050 HITFLG *=*+1
1060 TXL *=*+1 temporary values---slightly shifted
1070 TXH *=*+1
1080 HANDCP=$68F
1090 ;
1100  *=$5200
1110 PLYR0 *=*+128
1120 PLYR1 *=*+128
1130 PLYR2 *=*+128
1140 PLYR3 *=*+128
1150 CORPSX *=*+159 x-coords of all units (pixel frame)
1160 CORPSY *=*+159 y-coords of all units (pixel frame)
1170 MSTRNG *=*+159 muster strengths
1180 CSTRNG *=*+159 combat strengths
1190 SWAP *=*+159 terrain code underneath unit
1200 ARRIVE *=*+159 turn of arrival
1210 WORDS *=*+272 various words for messages
1220 CORPT *=*+159 codes for unit types
1230 CORPNO *=*+159 ID numbers of units
1240 HDIGIT *=*+256 tables for displaying numbers (hundreds)
1250 TDIGIT *=*+256 tens tables
1260 ODIGIT *=*+256 ones tables
1270 TXTTBL *=*+96 more text
1280 MONLEN *=*+13 table of month lengths
1290 HMORDS *=*+159 how many orders each unit has in queue
1300 WHORDS *=*+159 what the orders are
1310 WHORDH *=*+159
1320 BEEPTB *=*+4 table of beep tones
1330 ERRMSG *=*+128 table of error messages
1340 XOFF *=*+4 offsets for moving maltakreuze
1350 YOFF *=*+4
1360 MASKO *=*+4 mask values for decoding orders
1370 XADD *=*+4 offsets for moving arrow
1380 YADD *=*+4
1390 TRTAB *=*+13
1400 MLTKRZ *=*+8 maltese cross shape
1410 ;
1420 ;RAM from $6000 to $6430 is taken up by
1430 ;character sets and the display list
1440 ;
1450  *=$6431
1460 ARRTAB *=*+32 arrow shapes
1470  *=$6450
1480 TXTWDW *=$6CB1
1490 ;
1500 STKTAB *=*+16 a joystick decoding table
1510 SSNCOD *=*+12
1520 TRNTAB *=*+60
1530 BHX1 *=*+22
1540 BHY1 *=*+22
1550 BHX2 *=*+22
1560 BHY2 *=*+22
1570 EXEC *=*+159
1580 ;
1590 ;everything in here is taken up by the map data
1600 ;
1610 ;
1620 ;This is the vertical blank interrupt routine
1630 ;It reads the joystick and scrolls the screen
1640 ;
1650  *=$7400
1660  LDA TRIG1 check for break button
1670  BNE Z30 no, check next
1680  LDY #62 reset 60 Hertz vector
1690  LDX #233
1700  LDA #7
1710  JSR SETVBV
1720  PLA reset stack
1730  PLA
1740  PLA
1750  JMP $7210 break routine
1760 Z30 LDA HANDCP
1770  BEQ A31
1780  LDA TRIG0
1790  BEQ A31
1800  LDA #$08
1810  STA CONSOL
1820  LDA CONSOL
1830  AND #$04
1840  BNE A31
1850  STA HANDCP
1860  LDA #$30
1870  STA $7B7A my trademark
1880  LDX #$36
1890 LOOPJ LDA MSTRNG,X
1900  STA TEMPI
1910  LSR A
1920  ADC TEMPI
1930  BCC A22
1940  LDA #$FF
1950 A22 STA MSTRNG,X
1960  DEX
1970  BNE LOOPJ
1980 ;
1990 ;
2000 A31 LDA TRIG0 button status
2010  ORA BUTMSK button allowed?
2020  BEQ X17
2030  LDA BUTFLG no button now; previous status
2040  BNE X23
2050  JMP NOBUT
2060 X23 LDA #$58 button just released
2070  STA PCOLR0
2080  LDA #$00
2090  STA BUTFLG
2100  STA KRZFLG
2110  STA AUDC1
2120  LDX #$52
2130 LOOP8 STA TXTWDW+8,X clear text window
2140  DEX
2150  BPL LOOP8
2160  LDA #$08
2170  STA DELAY
2180  CLC
2190  ADC RTCLKL
2200  STA TIMSCL
2210  JSR SWITCH
2220  LDA #$00
2230  STA CORPS
2240  JSR CLRP1
2250  JSR CLRP2
2260  JMP ENDISR
2270 X17 STA ATRACT button is pressed
2280  LDA STICK
2290  AND #$0F
2300  EOR #$0F
2310  BEQ X20 joystick active?
2320  JMP ORDERS yes
2330 X20 STA DBTIMR no, set debounce
2340  STA AUDC1
2350  STA STKFLG
2360  LDA BUTFLG
2370  BNE BUTHLD is this the first button pass
2380  JMP FBUTPS yes
2390 BUTHLD JSR ERRCLR no, clear errors
2400 X61 LDA HITFLG
2410  BEQ X63 anybody in the window?
2420  JMP ENDISR no
2430 X63 LDA CH
2440  CMP #$21
2450  BNE X80 space bar pressed?
2460  LDX CORPS yes, check for Russian
2470  CPX #$37
2480  BCS X80
2490  LDA #$00
2500  STA CH
2510  STA HMORDS,X clear out orders
2520  STA HOWMNY
2530  STA STPCNT
2540  LDA #$01
2550  STA ORDCNT
2560  JSR CLRP1
2570  JSR CLRP2
2580  LDA BASEX
2590  STA STEPX
2600  LDA BASEY
2610  STA STEPY
2620 X80 LDA RTCLKL
2630  AND #$03
2640  BEQ X54 time to move arrow?
2650  JMP ENDISR no
2660 X54 LDY HOWMNY yes
2670  BNE X65 any orders to show?
2680  JMP PCURSE no, go ahead to maltakreuze
2690 X65 JSR CLRP1 yes, clear old arrow
2700  LDA ORDCNT
2710  LDX #$00 assume first byte
2720  CMP #$05
2730  BCC X52 second byte or first?
2740  INX second byte
2750 X52 AND #$03 isolate bit pair index
2760  TAY
2770  LDA BITTAB,Y get mask
2780 X50 AND ORD1,X get orders
2790 ;
2800 ;right justify orders
2810 ;
2820  DEY
2830  BPL X51
2840  LDY #$03
2850 X51 BEQ X53
2860 LOOP21 LSR A
2870  LSR A
2880  DEY
2890  BNE LOOP21
2900 X53 STA ARRNDX
2910  ASL A
2920  ASL A
2930  ASL A
2940 ;get arrow image and store it to player RAM
2950  TAX
2960  LDY STEPY
2970 X55 LDA ARRTAB,X
2980  CPY #$80
2990  BCS X43
3000  STA PLYR1,Y
3010 X43 INX
3020  INY
3030  TXA
3040  AND #$07
3050  BNE X55
3060 ;
3070  LDA STEPX position arrow
3080  STA HPOSP1
3090 ;
3100 ;now step arrow
3110 ;
3120  LDX ARRNDX
3130  LDA STEPX
3140  CLC
3150  ADC XADD,X
3160  STA STEPX
3170  LDA STEPY
3180  CLC
3190  ADC YADD,X
3200  STA STEPY
3210 ;
3220  INC STPCNT next step
3230  LDA STPCNT
3240  AND #$07
3250  BNE X59 if not done end ISR
3260  STA STPCNT end of steps
3270  INC ORDCNT next order
3280  LDA ORDCNT
3290  CMP HOWMNY last order?
3300  BCC X59 no, out
3310  BEQ X59 no, out
3320  LDA #$01
3330  STA ORDCNT yes, reset to start of arrow's path
3340 ;
3350 ;display maltese cross ('maltakreuze' or KRZ)
3360 ;
3370 PCURSE LDY STEPY
3380  STY KRZY
3390  LDA #$FF
3400  STA KRZFLG
3410  LDX #$00
3420 LOOP24 LDA MLTKRZ,X
3430  CPY #$80
3440  BCS X44
3450  STA PLYR2,Y
3460 X44 INY
3470  INX
3480  CPX #$08
3490  BNE LOOP24
3500  LDA STEPX
3510  SEC
3520  SBC #$01
3530  STA KRZX
3540  STA HPOSP2
3550  JSR CLRP1 clear arrow
3560  LDA BASEX reset arrow's coords
3570  STA STEPX
3580  LDA BASEY
3590  STA STEPY
3600 ;
3610 X59 JMP ENDISR
3620 ;
3630 ;FIRST BUTTON PASS
3640 ;looks for a unit inside cursor
3650 ;if there is one, puts unit info into text window
3660 ;
3670 FBUTPS LDA #$FF
3680  STA BUTFLG
3690 ;
3700 ;first get coords of center of cursor (map frame)
3710 ;
3720 X24 LDA CURSXL
3730  CLC
3740  ADC #$06
3750  STA TXL
3760  LDA CURSXH
3770  ADC #$00
3780  STA TXH
3790  LDA CURSYL
3800  CLC
3810  ADC #$09
3820  STA TYL
3830  LDA CURSYH
3840  ADC #$00
3850  STA TYH
3860  LDA TXH
3870  LSR A
3880  LDA TXL
3890  ROR A
3900  LSR A
3910  LSR A
3920 ;
3930 ;coords of cursor (pixel frame)
3940 ;
3950  STA CHUNKX
3960  LDA TYH
3970  LSR A
3980  TAX
3990  LDA TYL
4000  ROR A
4010  TAY
4020  TXA
4030  LSR A
4040  TYA
4050  ROR A
4060  LSR A
4070  LSR A
4080  STA CHUNKY
4090 ;
4100 ;now look for a match with unit coordinates
4110 ;
4120  LDX #$9E
4130 LOOP6 CMP CORPSY,X
4140  BEQ MAYBE
4150 X16 DEX
4160  BNE LOOP6
4170  STX CORPS no match obtained
4180  DEX
4190  STX HITFLG
4200  JMP ENDISR
4210 ;
4220 MAYBE LDA CHUNKX
4230  CMP CORPSX,X
4240  BNE X35
4250  LDA ARRIVE,X
4260  BMI X35
4270  CMP TURN
4280  BCC MATCH
4290  BEQ MATCH
4300 X35 LDA CHUNKY
4310  JMP X16
4320 ;
4330 ;match obtained
4340 ;
4350 MATCH LDA #$00
4360  STA HITFLG note match
4370  STA CH
4380  LDA #$5C
4390  STA PCOLR0 light up cursor
4400 ;
4410 ;display unit specs
4420 ;
4430  STX CORPS
4440  LDY #$0D
4450  LDA CORPNO,X ID number
4460  JSR DNUMBR
4470  INY
4480  LDX CORPS
4490  LDA CORPT,X first name
4500  STA TEMPI
4510  AND #$F0
4520  LSR A
4530  JSR ENTRY2
4540  LDA TEMPI
4550  AND #$0F second name
4560  CLC
4570  ADC #$08
4580  JSR DWORDS
4590  LDA #$1E
4600  LDX CORPS
4610  CPX #$37
4620  BCS X26
4630  LDA #$1D
4640 X26 JSR DWORDS display unit size (corps or army)
4650  LDY #$38
4660  LDA #$1F "MUSTER"
4670  JSR DWORDS
4680  DEY
4690  LDA #$1A ":"
4700  STA TXTWDW,Y
4710  INY
4720  INY
4730  LDX CORPS
4740  LDA MSTRNG,X muster strength
4750  JSR DNUMBR
4760  INY
4770  INY
4780  LDA #$20 "COMBAT"
4790  JSR DWORDS
4800  LDA #$21 "STRENGTH"
4810  JSR DWORDS
4820  DEY
4830  LDA #$1A ":"
4840  STA TXTWDW,Y
4850  INY
4860  INY
4870  LDX CORPS
4880  LDA CSTRNG,X combat strength
4890  JSR DNUMBR
4900 X27 JSR SWITCH flip unit with terrain
4910  LDA CORPS
4920  CMP #$37
4930  BCC X79 Russian?
4940  LDA #$FF yes, mask orders and exit
4950  STA HITFLG
4960  BMI X75
4970 ;
4980 ;German unit
4990 ;set up orders display
5000 ;first calculate starting coords (BASEX, BASEY)
5010 ;
5020 X79 LDA #$01
5030  STA ORDCNT
5040  LDA #$00
5050  STA STPCNT
5060 ;
5070  LDA TXL
5080  AND #$07
5090  CLC
5100  ADC #$01
5110  CLC
5120  ADC SHPOS0
5130  STA BASEX
5140  STA STEPX
5150 ;
5160  LDA TYL
5170  AND #$0F
5180  LSR A
5190  SEC
5200  SBC #$01
5210  CLC
5220  ADC SCY
5230  STA BASEY
5240  STA STEPY
5250 ;
5260 ;now set up page 6 values
5270 ;
5280  LDX CORPS
5290  LDA HMORDS,X
5300  STA HOWMNY
5310  LDA WHORDS,X
5320  STA ORD1
5330  LDA WHORDH,X
5340  STA ORD2
5350 X75 JMP ENDISR
5360 ;
5370 ;ORDERS INPUT ROUTINE
5380 ;
5390 ORDERS LDA STKFLG
5400  BNE X75
5410  LDX CORPS
5420  CPX #$37
5430  BCC X64 Russian?
5440  LDX #$00 yes, error
5450  JMP SQUAWK
5460 X64 LDA HMORDS,X
5470  CMP #$08
5480  BCC X66 only 8 orders allowed
5490  LDX #$20
5500  JMP SQUAWK
5510 X66 LDA KRZFLG
5520  BNE X67 must wait for maltakreuze
5530  LDX #$40
5540  JMP SQUAWK
5550 X67 INC DBTIMR
5560  LDA DBTIMR wait for debounce time
5570  CMP #$10
5580  BCS X68
5590  BCC X75
5600 X68 LDA #$00
5610  STA DBTIMR reset debounce timer
5620  LDX STICK
5630  LDA STKTAB,X
5640  BPL X69
5650  LDX #$60 no diagonal orders allowed
5660  JMP SQUAWK
5670 ;
5680 ;OK, this is a good order
5690 ;
5700 X69 TAY
5710  STA STICKI
5720  LDA BEEPTB,Y
5730  STA AUDF1 "BEEP!"
5740  LDA #$A8
5750  STA AUDC1
5760  LDA #$FF
5770  STA STKFLG
5780 ;
5790  LDX CORPS
5800  INC HMORDS,X
5810  LDA HMORDS,X
5820  STA HOWMNY
5830  SEC
5840  SBC #$01
5850  AND #$03
5860  TAY
5870  STY TEMPI
5880  LDA HMORDS,X
5890  SEC
5900  SBC #$01
5910  LSR A
5920  LSR A
5930  TAX
5940  LDA STICKI
5950 ;isolate order
5960 X71 DEY
5970  BMI X70
5980  ASL A
5990  ASL A
6000  JMP X71
6010 X70 LDY TEMPI
6020  EOR ORD1,X fold in new order (sneaky code)
6030  AND MASKO,Y
6040  EOR ORD1,X
6050  STA ORD1,X
6060  LDA ORD1
6070  LDX CORPS
6080  STA WHORDS,X
6090  LDA ORD2
6100  STA WHORDH,X
6110 ;
6120 ;move maltakreuze
6130 ;
6140  JSR CLRP2
6150  LDX STICKI
6160  LDA KRZX
6170  CLC
6180  ADC XOFF,X
6190  STA KRZX
6200  LDA KRZY
6210  CLC
6220  ADC YOFF,X
6230  STA KRZY
6240 DSPKRZ LDA KRZX display it
6250  STA HPOSP2
6260  LDY KRZY
6270  LDX #$00
6280 LOOP26 LDA MLTKRZ,X
6290  CPY #$80
6300  BCS X45
6310  STA PLYR2,Y
6320 X45 INY
6330  INX
6340  CPX #$08
6350  BNE LOOP26
6360  BEQ EXITI
6370 ;
6380 ;ERROR on inputs routine
6390 ;squawks speaker and puts out error message
6400 ;
6410 SQUAWK LDY #$69
6420 LOOP28 LDA ERRMSG,X
6430  SEC
6440  SBC #$20
6450  STA TXTWDW,Y
6460  INY
6470  INX
6480  TXA
6490  AND #$1F
6500  BNE LOOP28
6510  LDA #$68
6520  STA AUDC1
6530  LDA #$50
6540  STA AUDF1 "HONK!"
6550  LDA #$FF
6560  STA ERRFLG
6570  BMI EXITI
6580 ;
6590 ;NO BUTTON PRESSED ROUTINE
6600 ;
6610 NOBUT STA DBTIMR
6620  LDA STICK
6630  AND #$0F
6640  EOR #$0F
6650  BNE SCROLL
6660  STA AUDC1
6670  STA STKFLG
6680  LDA #$08
6690  STA DELAY
6700  CLC
6710  ADC RTCLKL
6720  STA TIMSCL
6730  JSR ERRCLR
6740 EXITI JMP ENDISR
6750 SCROLL LDA #$00
6760  STA ATRACT
6770 ;
6780 ;acceleration feature of cursor
6790 ;
6800  LDA TIMSCL
6810  CMP RTCLKL
6820  BNE EXITI
6830  LDA DELAY
6840  CMP #$01
6850  BEQ X21
6860  SEC
6870  SBC #$01
6880  STA DELAY
6890 X21 CLC
6900  ADC RTCLKL
6910  STA TIMSCL
6920 ;
6930  LDA #$00
6940  STA OFFLO
6950  STA OFFHI zero the offset
6960 ;
6970  LDA STICK get joystick reading
6980  PHA save it on stack for other bit checks
6990  AND #$08 joystick left?
7000  BNE CHKRT no, move on
7010  LDA CURSXL
7020  BNE X13
7030  LDX CURSXH
7040  BEQ CHKUP
7050 X13 SEC
7060  SBC #$01
7070  STA CURSXL
7080  BCS X14
7090  DEC CURSXH
7100 X14 LDA SHPOS0
7110  CMP #$BA
7120  BEQ X1
7130  CLC
7140  ADC #$01
7150  STA SHPOS0
7160  STA HPOSP0
7170  BNE CHKUP
7180 X1 LDA XPOSL
7190  SEC decrement x-coordinate
7200  SBC #$01
7210  STA XPOSL
7220  AND #$07
7230  STA HSCROLL fine scroll
7240  CMP #$07 scroll overflow?
7250  BNE CHKUP no, move on
7260  INC OFFLO yes, mark it for offset
7270  CLV
7280  BVC CHKUP no point in checking for joystick right
7290 CHKRT PLA get back joystick byte
7300  PHA save it again
7310  AND #$04 joystick right?
7320  BNE CHKUP no, move on
7330  LDA CURSXL
7340  CMP #$64
7350  BNE X12
7360  LDX CURSXH
7370  BNE CHKUP
7380 X12 CLC
7390  ADC #$01
7400  STA CURSXL
7410  BCC X15
7420  INC CURSXH
7430 X15 LDA SHPOS0
7440  CMP #$36
7450  BEQ X2
7460  SEC
7470  SBC #$01
7480  STA SHPOS0
7490  STA HPOSP0
7500  BNE CHKUP
7510 X2 LDA XPOSL
7520  CLC no, increment x-coordinate
7530  ADC #$01
7540  STA XPOSL
7550 X4 AND #$07
7560  STA HSCROLL fine scroll
7570  BNE CHKUP scroll overflow? if not, move on
7580  DEC OFFLO yes, set up offset for character scroll
7590  DEC OFFHI
7600 CHKUP PLA joystick up?
7610  LSR A
7620  PHA
7630  BCS CHKDN no, ramble on
7640  LDA CURSYL
7650  CMP #$5E
7660  BNE X3
7670  LDX CURSYH
7680  CPX #$02
7690  BEQ CHKDN
7700 X3 INC CURSYL
7710  BNE X11
7720  INC CURSYH
7730 X11 LDX SCY
7740  CPX #$1B
7750  BEQ X6
7760  INC CURSYL
7770  BNE X18
7780  INC CURSYH
7790 X18 DEX
7800  STX SCY
7810  TXA
7820  CLC
7830  ADC #$12
7840  STA TEMPI
7850 LOOP4 LDA PLYR0,X
7860  STA PLYR0-1,X
7870  INX
7880  CPX TEMPI
7890  BNE LOOP4
7900  BEQ CHKDN
7910 X6 LDA YPOSL
7920  SEC
7930  SBC #$01
7940  BCS X7
7950  DEC YPOSH
7960 X7 STA YPOSL
7970  AND #$0F
7980  STA VSCROLL fine scroll
7990  CMP #$0F
8000  BNE CHKDN scroll overflow? If not, amble on
8010  LDA OFFLO yes, set up offset for character scroll
8020  SEC
8030  SBC #$30
8040  STA OFFLO
8050  LDA OFFHI
8060  SBC #$00
8070  STA OFFHI
8080 CHKDN PLA joystick down?
8090  LSR A
8100  BCS CHGDL no, trudge on
8110  LDA CURSYL
8120  CMP #$02
8130  BNE X5
8140  LDX CURSYH
8150  BEQ CHGDL
8160 X5 SEC
8170  SBC #$01
8180  STA CURSYL
8190  BCS X10
8200  DEC CURSYH
8210 X10 LDX SCY
8220  CPX #$4E
8230  BEQ X8
8240  SEC
8250  SBC #$01
8260  STA CURSYL
8270  BCS X19
8280  DEC CURSYH
8290 X19 INX
8300  STX SCY
8310  TXA
8320  CLC
8330  ADC #$12
8340  DEX
8350  DEX
8360  STX TEMPI
8370  TAX
8380 LOOP5 LDA PLYR0-1,X
8390  STA PLYR0,X
8400  DEX
8410  CPX TEMPI
8420  BNE LOOP5
8430  BEQ CHGDL
8440 X8 LDA YPOSL
8450  CLC no, decrement y-coordinate
8460  ADC #$01
8470  STA YPOSL
8480  BCC X9
8490  INC YPOSH
8500 X9 AND #$0F
8510  STA VSCROLL fine scroll
8520  BNE CHGDL no, move on
8530  LDA OFFLO yes, mark offset
8540  CLC
8550  ADC #$30
8560  STA OFFLO
8570  LDA OFFHI
8580  ADC #$00
8590  STA OFFHI
8600 ;
8610 ;In this loop we add the offset values to the existing
8620 ;LMS addresses of all display lines.
8630 ;This scrolls the characters.
8640 ;
8650 CHGDL LDY #$09
8660 DLOOP LDA (DLSTPT),Y
8670  CLC
8680  ADC OFFLO
8690  STA (DLSTPT),Y
8700  INY
8710  LDA (DLSTPT),Y
8720  ADC OFFHI
8730  STA (DLSTPT),Y
8740  INY
8750  INY
8760  CPY #$27
8770  BNE DLOOP
8780 ;
8790 ENDISR LDA YPOSH
8800  LSR A
8810  LDA YPOSL
8820  ROR A
8830  LSR A
8840  LSR A
8850  LSR A
8860  CMP #$11
8870  BCS X39
8880  LDA #$FF
8890  BMI X40
8900 X39 CMP #$1A
8910  BCC X41
8920  LDA #$02
8930  BPL X40
8940 X41 STA TEMPI
8950  INX
8960  LDA #$1D
8970  SEC
8980  SBC TEMPI
8990 X40 STA CNT1
9000  LDA #$00
9010  STA CNT2
9020  JMP XITVBV exit vertical blank routine
9030 ;
9040  *=$799C
9050 JSTP .BYTE 0,0,0,0,3,3,3,3
9060  .BYTE 2,2,2,2,1,1,1,0
9070  .BYTE 0,0,3,3,2,2,1,0
9080 DEFNC .BYTE 2,3,3,2,2,2,1,1,2,0
9090  *=$79C0
9100 ;
9110 ;SUBROUTINE DWORDS
9120 ;displays a single word from a long table of words
9130 ;
9140 DWORDS ASL A
9150  ASL A
9160  ASL A
9170  BCC ENTRY2
9180  TAX
9190 BOOP20 LDA WORDS+256,X
9200  SEC
9210  SBC #$20
9220  BEQ BNDW
9230  STA TXTWDW,Y
9240  INY
9250  INX
9260  TXA
9270  AND #$07
9280  BNE BOOP20
9290 BNDW INY
9300  RTS
9310 ENTRY2 TAX this is another entry point
9320 LOOP20 LDA WORDS,X
9330  SEC
9340  SBC #$20
9350  BEQ NDW
9360  STA TXTWDW,Y
9370  INY
9380  INX
9390  TXA
9400  AND #$07
9410  BNE LOOP20
9420 NDW INY
9430  RTS
9440 ;
9450 ;
9460 ;SUBROUTINE SWITCH FOR SWAPPING CORPS WITH TERRAIN
9470 ;
9480 SWITCH LDA #$00
9490  STA MAPHI
9500  LDA #$27
9510  SEC
9520  SBC CHUNKY
9530  ASL A
9540  ROL MAPHI
9550  ASL A
9560  ROL MAPHI
9570  ASL A
9580  ROL MAPHI
9590  ASL A
9600  ROL MAPHI
9610  STA TEMPLO
9620  LDX MAPHI
9630  STX TEMPHI
9640  ASL A
9650  ROL MAPHI
9660  CLC
9670  ADC TEMPLO
9680  STA MAPLO
9690  LDA MAPHI
9700  ADC TEMPHI
9710  ADC #$65
9720  STA MAPHI
9730  LDA #46
9740  SEC
9750  SBC CHUNKX
9760  TAY
9770  LDA (MAPLO),Y
9780  LDX CORPS
9790  BEQ X34
9800  PHA
9810  LDA SWAP,X
9820  STA (MAPLO),Y
9830  PLA
9840  STA SWAP,X
9850 X34 RTS
9860 ;
9870 ;SUBROUTINE CLRP1
9880 ;clears the arrow player
9890 ;
9900 CLRP1 LDA #$00
9910  LDY STEPY
9920  DEY
9930  TAX
9940 LOOP23 CPY #$80
9950  BCS X22
9960  STA PLYR1,Y
9970 X22 INY
9980  INX
9990  CPX #$0B
010000  BNE LOOP23
010010  RTS
010020 ;
010030 ;SUBROUTINE CLRP2
010040 ;clears the maltakreuze
010050 ;
010060 CLRP2 LDA #$00
010070  LDY KRZY
010080  TAX
010090 LOOP25 CPY #$80
010100  BCS X42
010110  STA PLYR2,Y
010120 X42 INY
010130  INX
010140  CPX #$0A
010150  BNE LOOP25
010160  RTS
010170 ;
010180 ;SUBROUTINE ERRCLR
010190 ;clears sound and the text window
010200 ;
010210 ERRCLR LDA ERRFLG
010220  BPL ENDERR
010230  LDA #$00
010240  STA ERRFLG
010250  LDY #$86
010260  LDX #$1F
010270 LOOP29 STA TXTWDW,Y
010280  DEY
010290  DEX
010300  BPL LOOP29
010310 ENDERR RTS
010320 ;
010330 BITTAB .BYTE $C0,3,$C,$30
010340 ROTARR .BYTE 4,9,14,19,24
010350  .BYTE 3,8,13,18,23
010360  .BYTE 2,7,12,17,22
010370  .BYTE 1,6,11,16,21
010380  .BYTE 0,5,10,15,20
010390 OBJX *=*+104
010400 ;
010410 ;From here to $7B00 is expansion RAM
010420 ;
010430 ;This is the DLI routine
010440 ;
010450  *=$7B00
010460 DLISRV PHA
010470  TXA
010480  PHA
010490  INC CNT2
010500  LDA CNT2
010510  CMP CNT1
010520  BNE OVER1
010530  LDX #$62 map DLI
010540  LDA #$28
010550  EOR COLRSH
010560  AND DRKMSK
010570  STA WSYNC
010580  STX CHBASE
010590  STA COLPF0
010600  JMP DLIOUT
010610 ;
010620 OVER1 CMP #$0F
010630  BNE OVER6
010640  LDA #$3A
010650  EOR COLRSH
010660  AND DRKMSK
010670  TAX
010680  LDA #$00
010690  EOR COLRSH
010700  AND DRKMSK
010710  STA WSYNC
010720  STX COLPF2
010730  STA COLPF1
010740  JMP DLIOUT
010750 ;
010760 OVER6 CMP #$01
010770  BNE OVER2
010780  LDA TRCOLR green tree color
010790  EOR COLRSH
010800  AND DRKMSK
010810  TAX
010820  LDA #$1A yellow band at top of map
010830  EOR COLRSH
010840  AND DRKMSK
010850  STA WSYNC
010860  STA COLBAK
010870  STX COLPF0
010880  LDA #$60
010890  STA CHBASE
010900  JMP DLIOUT
010910 ;
010920 OVER2 CMP #$03
010930  BNE OVER3
010940  LDA EARTH top of map
010950  EOR COLRSH
010960  AND DRKMSK
010970  STA WSYNC
010980  STA COLBAK
010990  JMP DLIOUT
011000 ;
011010 OVER3 CMP #$0D
011020  BNE OVER4
011030  LDX #$E0 bottom of map
011040  LDA #$22
011050  EOR COLRSH
011060  AND DRKMSK
011070  STA WSYNC
011080  STA COLPF2
011090  STX CHBASE
011100  JMP DLIOUT
011110 ;
011120 OVER4 CMP #$0E
011130  BNE OVER5
011140  LDA #$8A bright blue strip
011150  EOR COLRSH
011160  AND DRKMSK
011170  STA WSYNC
011180  STA COLBAK
011190  JMP DLIOUT
011200 ;
011210 OVER5 CMP #$10
011220  BNE DLIOUT
011230  LDA #$D4 green bottom
011240  EOR COLRSH
011250  AND DRKMSK
011260  PHA some extra delay
011270  PLA
011280  NOP
011290  STA COLBAK
011300 ;
011310 DLIOUT PLA
011320  TAX
011330  PLA
011340  RTI
011350 ;
011360 ;SUBROUTINE DNUMBR
011370 ;displays a number with leading zero suppress
011380 ;
011390 DNUMBR TAX
011400  CLC
011410  LDA HDIGIT,X
011420  BEQ X36
011430  ADC #$10
011440  STA TXTWDW,Y
011450  INY
011460  SEC
011470 X36 LDA TDIGIT,X
011480  BCS X38
011490  BEQ X37
011500 X38 CLC
011510  ADC #$10
011520  STA TXTWDW,Y
011530  INY
011540 X37 LDA ODIGIT,X
011550  CLC
011560  ADC #$10
011570  STA TXTWDW,Y
011580  INY
011590  RTS
011600 ;
011610 NDX .BYTE 0,1,2,3,4,9,14,19
011620  .BYTE 24,23,22,21,20,15,10,5
011630  .BYTE 6,7,8,13,18,17,16,11
011640 YINC .BYTE 1
011650 XINC .BYTE 0,$FF,0,1
011660 OFFNC .BYTE 1,1,1,1,1,1,2,2,1,0
011670  .END

David Leaver                       10 Goodparla St,
e-mail leaver@netinfo.com.au       Hawker, ACT 2614
       leaver@alphalink.com.au     Australia